# 🍅 Quick Start Guide

## Installation

```bash
cd /home/shantanu/pomo-app/pomo-cli-integrated
go build -o pomo-cli main.go
sudo mv pomo-cli /usr/local/bin/
```

## First Time Setup

```bash
# Initialize database
pomo-cli init
```

## Basic Workflow

### 1. Add a Task

```bash
pomo-cli add "Complete project documentation" -p 4 -d 25m -t "work,docs"
```

**Output:**
```
1
```
(Task ID is returned)

### 2. List Tasks

```bash
pomo-cli list
```

**Output:**
```
1: [] [25m0s] [X X X X] [work docs] - Complete project documentation
```

### 3. Start Timer

```bash
pomo-cli start 1
```

**What happens:**
1. Opens full-screen interactive UI
2. Shows countdown timer (25:00 → 00:00)
3. Displays progress bar
4. Accepts keyboard controls
5. Sends notification when complete
6. Prompts for break

### 4. During Timer

**Keyboard Controls:**
- Press `Space` → Pause/Resume
- Press `S` → Stop and complete
- Press `Q` → Quit

### 5. After Completion

```
✓ Pomodoro completed!

Take a short break (5 minutes)

Press any key to start break, or 'q' to quit...
```

### 6. View Sessions

```bash
pomo-cli sessions 1
```

**Output:**
```
ID       Task     Start               End                 Completed 
------------------------------------------------------------------------
1        1        2025-10-13 14:30    2025-10-13 14:55    Yes
```

## Interactive UI Preview

```
┌────────────────────────────────────────────────────┐
│  🍅 POMODORO TIMER                                 │
│                                                    │
│  Task: Complete project documentation             │
│  Tags: work, docs                                 │
│                                                    │
│  Progress: 1/4 pomodoros                          │
│                                                    │
│  23:45                                            │
│                                                    │
│  ▶  RUNNING                                       │
│                                                    │
│  [████████████████████████░░░░░░░░░░░░░░] 68%     │
│                                                    │
│  Controls:                                         │
│    [Space/P] Pause/Resume                         │
│    [S]       Stop and complete                    │
│    [Q]       Quit                                 │
└────────────────────────────────────────────────────┘
```

## Common Commands

```bash
# Add tasks
pomo-cli add "Write tests" -p 2 -d 25m
pomo-cli add "Code review" -p 1 -d 30m -t "review,urgent"

# List tasks
pomo-cli list                    # All tasks
pomo-cli list --limit 5          # Last 5 tasks
pomo-cli list --json             # JSON format

# Start timer
pomo-cli start 1                 # Interactive UI opens

# Check status (in another terminal)
pomo-cli status                  # Human readable
pomo-cli status --json           # JSON format

# Complete session manually
pomo-cli complete 1 --notes "Finished early"

# View sessions
pomo-cli sessions 1              # For specific task
```

## Tips

### 1. Multiple Terminals

```bash
# Terminal 1: Run timer
pomo-cli start 1

# Terminal 2: Check status
watch -n 1 pomo-cli status
```

### 2. Status Bar Integration

**Polybar:**
```ini
[module/pomo]
type = custom/script
interval = 1
exec = pomo-cli status
```

**i3blocks:**
```ini
[pomo]
command=pomo-cli status
interval=1
```

### 3. Custom Durations

```bash
# Short pomodoro
pomo-cli add "Quick task" -d 15m

# Deep work session
pomo-cli add "Deep focus" -d 50m

# Multiple short sessions
pomo-cli add "Sprint tasks" -p 6 -d 20m
```

### 4. Notifications

Ensure `notify-send` is installed:

```bash
# Ubuntu/Debian
sudo apt install libnotify-bin

# Arch Linux
sudo pacman -S libnotify

# Test
notify-send "Test" "Working!"
```

## Keyboard Shortcuts Cheat Sheet

| Key | Action | When |
|-----|--------|------|
| `Space` | Pause/Resume | During timer |
| `P` | Pause/Resume | During timer |
| `S` | Stop & Complete | During timer |
| `Q` | Quit | Anytime |
| `Ctrl+C` | Force quit | Emergency |

## Timer States

### 🟢 Running (Green)
- Timer is counting down
- Press Space to pause

### 🔴 Paused (Red)
- Timer is frozen
- Press Space to resume

### 🟡 Break (Yellow)
- Pomodoro complete
- Taking 5/15 minute break

## Demo

Try the included demo:

```bash
./demo-timer.sh
```

This creates a 1-minute test task so you can try all features quickly.

## Help

```bash
pomo-cli --help          # Show all commands
pomo-cli add --help      # Command-specific help
```

## Troubleshooting

**Problem:** Timer not visible
```bash
# Reset terminal
reset
```

**Problem:** Notifications not working
```bash
# Check notify-send
which notify-send
notify-send "Test" "Message"
```

**Problem:** Keyboard not responding
```bash
# Restore terminal
stty sane
```

## API Sync (Optional)

If you have the API server running:

```bash
# Set API URL
export POMO_API_URL="http://localhost:3000"

# Push local data to API
pomo-cli sync-to-api

# Pull data from API
pomo-cli sync-from-api
```

## Files and Locations

```
~/.local/share/pomo/pomo.db    # Local database
~/.config/pomo/config.json     # Configuration (optional)
```

## Next Steps

1. ✅ Start with the demo: `./demo-timer.sh`
2. ✅ Add your first real task
3. ✅ Run a full 25-minute pomodoro
4. ✅ Review your session history
5. ✅ Set up status bar integration (optional)
6. ✅ Configure custom colors (optional)

---

**Happy focusing! 🍅**

For more details, see:
- [INTERACTIVE_TIMER.md](INTERACTIVE_TIMER.md) - Full timer documentation
- [FEATURES.md](FEATURES.md) - Feature comparison
- [README.md](README.md) - Complete documentation


