'use client';

import React from 'react';
import { CheckCircle2, Calendar, Clock, Video } from 'lucide-react';
import { InlineWidget } from 'react-calendly';
import { Section } from '../../components/ui/Section';

export const BookDemoPageContent: React.FC = () => {

  return (
    <Section id="book-demo" className="pt-32 pb-20 md:pt-28 md:pb-32" theme="contact">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-6 md:mb-16">
          <div className="inline-block px-3 py-1 rounded-full bg-brand-orange/10 text-brand-orange font-bold text-xs uppercase tracking-wider mb-4">
            Schedule Your Demo
          </div>
          <h1 className="text-2xl md:text-4xl lg:text-5xl font-bold text-brand-navy dark:text-white mb-2">
            Book a Personalized Demo
          </h1>
          <p className="text-lg md:text-xl text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
            Choose a time that works for you. We'll show you exactly how knowbuild maps to your specific inquiry, sales, and dispatch flows.
          </p>
        </div>

        {/* Benefits Grid */}
        <div className="grid md:grid-cols-3 gap-6 mb-6">
          {[
            {
              icon: Calendar,
              title: 'Choose Your Time',
              description: 'Pick a slot that fits your schedule',
            },
            {
              icon: Clock,
              title: '30-Minute Session',
              description: 'Focused walkthrough tailored to your needs',
            },
            {
              icon: Video,
              title: 'Live Demo',
              description: 'See knowbuild in action with real examples',
            },
          ].map((benefit, i) => (
            <div
              key={i}
              className="bg-white dark:bg-slate-800 p-6 rounded-2xl border border-slate-200 dark:border-slate-700 shadow-sm"
            >
              <div className="bg-brand-blue/10 p-1 rounded-xl w-fit mb-4">
                <benefit.icon className="text-brand-blue" size={24} />
              </div>
              <h3 className="font-bold text-brand-navy dark:text-white mb-2">{benefit.title}</h3>
              <p className="text-sm text-slate-600 dark:text-slate-400">{benefit.description}</p>
            </div>
          ))}
        </div>

        {/* What to Expect */}
  

        {/* Calendly Embed */}
        <div className="bg-white dark:bg-slate-900 rounded-3xl shadow-2xl shadow-slate-200/50 dark:shadow-black/30 border border-slate-200 dark:border-slate-700 ">
          <InlineWidget
            url="https://calendly.com/knowbuildbusinesssoftwareltd/30min"
            styles={{
              height: '700px',
              minWidth: '320px',
            }}
            pageSettings={{
              backgroundColor: 'ffffff',
              hideEventTypeDetails: false,
              hideLandingPageDetails: false,
              primaryColor: '00a2ff',
              textColor: '4d5055',
            }}
          />
          {/* 
            Replace the url above with your actual Calendly URL.
            Format: https://calendly.com/[your-username]/[event-type]
            Example: https://calendly.com/knowbuild/demo
            
            You can customize the pageSettings to match your brand colors:
            - primaryColor: Your brand color (hex format)
            - textColor: Text color for the widget
            - backgroundColor: Background color
          */}
        </div>
        <div className="mt-12">
          <h2 className="text-2xl font-bold text-brand-navy dark:text-white mb-6 text-center">
            What to Expect
          </h2>
          <div className="grid md:grid-cols-2 gap-4 max-w-4xl mx-auto">
            {[
              'Custom walkthrough for your business type',
              'Clear rollout plan & implementation timelines',
              'Honest fit assessment before any recommendation',
              'Q&A session to address your specific questions',
            ].map((item, i) => (
              <div
                key={i}
                className="flex gap-3 items-center p-4 bg-white dark:bg-slate-800 rounded-xl border border-slate-100 dark:border-slate-700"
              >
                <div className="bg-emerald-100 dark:bg-emerald-900/30 p-1 rounded-full flex-shrink-0">
                  <CheckCircle2 className="text-emerald-600 dark:text-emerald-400 w-5 h-5" />
                </div>
                <span className="text-slate-700 dark:text-slate-200 font-medium">{item}</span>
              </div>
            ))}
          </div>
        </div>
      </div>
    </Section>
  );
};

