import type { Metadata } from 'next';
import { BookDemoPageContent } from './BookDemoPageContent';
import { seoConfig } from '../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.bookDemo.title,
  description: seoConfig.bookDemo.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.bookDemo.url}`,
  },
  openGraph: {
    title: seoConfig.bookDemo.title,
    description: seoConfig.bookDemo.description,
    url: `https://knowbuild.com${seoConfig.bookDemo.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.bookDemo.title,
    description: seoConfig.bookDemo.description,
  },
};

export default function BookDemoPage() {
  return <BookDemoPageContent />;
}










