import type { Metadata } from 'next';
import Script from 'next/script';
import { ClientLayout } from '../components/ClientLayout';
import { JsonLd } from '../components/JsonLd';
import './globals.css';

export const metadata: Metadata = {
  title: 'KnowBuild | Advanced QERP.CRM for Growing B2B SMEs',
  description: 'The Second Brain for your SME. Connect inquiries, quotes, finance, and operations in one single operating system.',
  metadataBase: new URL('https://knowbuild.com'),
  icons: {
    icon: [
      { url: '/favicon-32x32.png', sizes: '32x32', type: 'image/png' },
      { url: '/favicon-16x16.png', sizes: '16x16', type: 'image/png' },
    ],
    apple: [
      { url: '/apple-touch-icon.png', sizes: '180x180', type: 'image/png' },
    ],
  },
  manifest: '/site.webmanifest',
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en" className="scroll-smooth">
      <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes" />
        <JsonLd />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossOrigin="anonymous" />
        <script
          dangerouslySetInnerHTML={{
            __html: `
              (function() {
                try {
                  var theme = localStorage.getItem('theme');
                  var supportDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches === true;
                  var isNight = new Date().getHours() >= 19 || new Date().getHours() < 6;
                  
                  if (theme === 'dark' || (!theme && (supportDarkMode || isNight))) {
                    document.documentElement.classList.add('dark');
                  } else {
                    document.documentElement.classList.remove('dark');
                  }
                } catch (e) {}
              })();
            `,
          }}
        />
      </head>
      <body className="font-sans text-slate-900 dark:text-slate-100 antialiased bg-[#F8FAFC] dark:bg-[#0B1220] overflow-x-hidden transition-colors duration-300">
        <Script
          src="https://www.googletagmanager.com/gtag/js?id=G-9NK7RNKWDX"
          strategy="afterInteractive"
        />
        <Script id="google-analytics" strategy="afterInteractive">
          {`
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());

            gtag('config', 'G-9NK7RNKWDX');
          `}
        </Script>
        <ClientLayout>{children}</ClientLayout>
      </body>
    </html>
  );
}














