import type { Metadata } from 'next';
import { PricingPageContent } from '../PricingPageContent';
import { seoConfig } from '../../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.pricing.title,
  description: seoConfig.pricing.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.pricing.url}`,
  },
  openGraph: {
    title: seoConfig.pricing.title,
    description: seoConfig.pricing.description,
    url: `https://knowbuild.com${seoConfig.pricing.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.pricing.title,
    description: seoConfig.pricing.description,
  },
};

export default function PricingPage() {
  return <PricingPageContent />;
}







