import type { Metadata } from 'next';
import { PrivacyPolicyContent } from './PrivacyPolicyContent';
import { seoConfig } from '../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.privacyPolicy.title,
  description: seoConfig.privacyPolicy.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.privacyPolicy.url}`,
  },
  openGraph: {
    title: seoConfig.privacyPolicy.title,
    description: seoConfig.privacyPolicy.description,
    url: `https://knowbuild.com${seoConfig.privacyPolicy.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.privacyPolicy.title,
    description: seoConfig.privacyPolicy.description,
  },
};

export default function PrivacyPolicyPage() {
  return <PrivacyPolicyContent />;
}


























