import type { MetadataRoute } from 'next';
import { seoConfig } from '../utils/seo-config';

const baseUrl = 'https://knowbuild.com';

/** Pages to include in sitemap. Excludes mindset (blocked via robots.txt). */
const SITEMAP_PATHS = [
  seoConfig.home.url,
  seoConfig.solutions.url,
  seoConfig.solutionsOverview.url,
  seoConfig.questions.url,
  seoConfig.contact.url,
  seoConfig.bookDemo.url,
  seoConfig.pricing.url,
  seoConfig.privacyPolicy.url,
  seoConfig.termsOfService.url,
];

export default function sitemap(): MetadataRoute.Sitemap {
  const now = new Date();
  return SITEMAP_PATHS.map((path) => ({
    url: `${baseUrl}${path === '/' ? '' : path}`,
    lastModified: now,
    changeFrequency: path === '/' ? 'weekly' : ('monthly' as const),
    priority: path === '/' ? 1 : 0.8,
  }));
}
