"use client";

import { motion } from "framer-motion";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { cn } from "@/lib/utils";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/Button";
import Image from "next/image";
import { ArrowUp } from "lucide-react";

const container = {
  hidden: { opacity: 0 },
  show: {
    opacity: 1,
    transition: {
      staggerChildren: 0.08,
      delayChildren: 0.12,
      when: "beforeChildren",
    },
  },
};

const item = {
  hidden: { opacity: 0, y: 16 },
  show: { opacity: 1, y: 0 },
};

const sections = [
  { id: "about", title: "1. About KnowBuild" },
  { id: "eligibility", title: "2. Eligibility and Account Use" },
  { id: "use-of-services", title: "3. Use of Services" },
  { id: "proprietary-rights", title: "4. Proprietary Rights and IP" },
  { id: "data-user-content", title: "5. Data and User Content" },
  { id: "forum", title: "6. Forum and Community Guidelines" },
  { id: "service-availability", title: "7. Service Availability and Disclaimers" },
  { id: "limitation-liability", title: "8. Limitation of Liability" },
  { id: "governing-law", title: "9. Governing Law and Jurisdiction" },
  { id: "changes", title: "10. Changes to These Terms" },
];

export function TermsOfServiceContent() {
  return (
    <div className="container mx-auto px-4 py-10 md:py-16 pt-32">
      <motion.header
        initial={{ opacity: 0, y: 12 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.4, ease: "easeOut" }}
        className="mb-8 md:mb-12 w-[80%] md:w-[60%] lg:w-[50%] mx-auto text-center"
      >
        <Badge className="mb-3 w-fit">
          Terms of Service
        </Badge>
        <div className="text-brand-blue text-3xl flex flex-col md:flex-row items-center justify-center gap-x-3 gap-y-2 font-bold font-stretch-50% tracking-tight md:text-4xl">
          <h1>Terms of Service —</h1>
          <div className="p-2 rounded-lg">
             <Image
                src={"https://knowbuildwebsiteassets.s3.ap-south-1.amazonaws.com/logo.svg"}
                alt="knowbuild_logo_tos_page"
                height={40}
                width={150}
                className="h-10 w-auto"
            />
          </div>
        </div>
        <p className="mt-2 text-sm text-slate-500 dark:text-slate-400 md:text-base">
          Last Updated: 23 December 2025
        </p>
      </motion.header>

      <div className="grid gap-8 md:grid-cols-12">
        {/* Table of contents */}
        <motion.nav
          initial={{ opacity: 0, y: 12 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.4, ease: "easeOut", delay: 0.05 }}
          aria-label="Table of contents"
          className="md:col-span-4 lg:col-span-3 order-2 md:order-1"
        >
          <Card className="sticky top-24">
            <CardHeader className="pb-4">
              <CardTitle className="text-base">On this page</CardTitle>
            </CardHeader>
            <CardContent className="flex flex-col gap-2 pb-5 text-sm">
              {sections.map((s) => (
                <a
                  key={s.id}
                  href={`#${s.id}`}
                  className={cn(
                    "rounded-md px-2 py-1.5 text-slate-500 dark:text-slate-400 transition-colors",
                    "hover:text-slate-900 dark:hover:text-white hover:bg-brand-blue/10"
                  )}
                >
                  {s.title}
                </a>
              ))}
            </CardContent>
          </Card>
        </motion.nav>

        {/* Content */}
        <section className="md:col-span-8 lg:col-span-9 order-1 md:order-2">
          <motion.div
            variants={container}
            initial="hidden"
            animate="show"
            className="flex flex-col gap-6"
          >
            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
              className="bg-white/70 dark:bg-brand-navy/70 backdrop-blur-md rounded-lg"
            >
              <Card id="intro" aria-labelledby="intro-heading">
                <CardHeader>
                  <CardTitle
                    id="intro-heading"
                    className="text-xl flex items-center flex-wrap gap-2"
                  >
                    Welcome to
                    <div className="px-2 py-1 rounded inline-flex items-center">
                      <Image
                        src={"https://knowbuildwebsiteassets.s3.ap-south-1.amazonaws.com/logo.svg"}
                        width={110}
                        height={50}
                        alt="knowbuild_logo_tos_page"
                        className="inline-block h-6 w-auto"
                      />
                    </div>
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-4">
                    These Terms of Service ("Terms") govern your access to and use of the KnowBuild® website, platform, applications, products, services, and related content (collectively, the "Services"). By accessing or using KnowBuild®, you agree to be bound by these Terms. If you do not agree with these Terms, please do not use the Services.
                  </p>
                  <p className="mb-0">
                    The Services are operated by KnowBuild Business Software Private Limited.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="about" aria-labelledby="about-heading">
                <CardHeader>
                  <CardTitle id="about-heading" className="text-xl">
                    1. About KnowBuild
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    KnowBuild® is a registered trademark. KnowBuild provides a proprietary business operating system, including CRM, ERP, QERP, and related modules, designed for B2B businesses and SMEs. All software, workflows, system designs, modules, documentation, and intellectual property associated with KnowBuild are proprietary to KnowBuild unless expressly stated otherwise.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="eligibility" aria-labelledby="eligibility-heading">
                <CardHeader>
                  <CardTitle id="eligibility-heading" className="text-xl">
                    2. Eligibility and Account Use
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    You must be legally capable of entering into a binding contract to use the Services. You represent that you are using the Services for legitimate business purposes. You are responsible for maintaining the confidentiality of your account credentials and all activities carried out under your account.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="use-of-services" aria-labelledby="use-heading">
                <CardHeader>
                  <CardTitle id="use-heading" className="text-xl">
                    3. Use of Services
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    You agree to use KnowBuild only for lawful business purposes and shall not copy, modify, distribute, sell, lease, sublicense, or reverse engineer any part of the Services.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="proprietary-rights" aria-labelledby="rights-heading">
                <CardHeader>
                  <CardTitle id="rights-heading" className="text-xl">
                    4. Proprietary Rights and Intellectual Property
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    KnowBuild® and all related modules, features, workflows, interfaces, logic, configurations, and system architecture are proprietary and owned exclusively by KnowBuild. Nothing in these Terms grants any ownership rights to users.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="data-user-content" aria-labelledby="data-heading">
                <CardHeader>
                  <CardTitle id="data-heading" className="text-xl">
                    5. Data and User Content
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    You retain ownership of business data you input into the platform. KnowBuild processes such data solely for providing and improving the Services.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="forum" aria-labelledby="forum-heading">
                <CardHeader>
                  <CardTitle id="forum-heading" className="text-xl">
                    6. Forum and Community Guidelines
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    KnowBuild may offer forums allowing users to ask questions or share insights. Forum content does not constitute professional advice and may be moderated.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="service-availability" aria-labelledby="availability-heading">
                <CardHeader>
                  <CardTitle id="availability-heading" className="text-xl">
                    7. Service Availability and Disclaimers
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    The Services are provided on an "as is" and "as available" basis without warranties of any kind.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="limitation-liability" aria-labelledby="liability-heading">
                <CardHeader>
                  <CardTitle id="liability-heading" className="text-xl">
                    8. Limitation of Liability
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    To the maximum extent permitted by law, KnowBuild shall not be liable for indirect or consequential damages. Total liability shall not exceed fees paid in the preceding twelve months.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="governing-law" aria-labelledby="law-heading">
                <CardHeader>
                  <CardTitle id="law-heading" className="text-xl">
                    9. Governing Law and Jurisdiction
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    These Terms shall be governed by and construed in accordance with the laws of India. Courts located in New Delhi, India shall have exclusive jurisdiction.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="changes" aria-labelledby="changes-heading">
                <CardHeader>
                  <CardTitle id="changes-heading" className="text-xl">
                    10. Changes to These Terms
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    KnowBuild may update these Terms from time to time. Continued use of the Services constitutes acceptance.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div variants={item} transition={{ duration: 0.36, ease: "easeOut" }}>
              <Card id="trademark" aria-labelledby="trademark-heading">
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                   <p className="font-semibold text-center">
                    KnowBuild® is a registered trademark. All KnowBuild modules, systems, workflows, and designs are proprietary.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <div className="flex justify-end w-full">
              <Button
                className="mt-2 w-fit"
                onClick={(e) => {
                  e.preventDefault();
                  document.getElementById('intro')?.scrollIntoView({ behavior: 'smooth' });
                  window.history.replaceState(null, '', '#intro');
                }}
              >
                <span>
                  <ArrowUp className="mr-2 h-4 w-4" />
                </span>
                Back to top
              </Button>
            </div>
          </motion.div>
        </section>
      </div>
    </div>
  );
}




