import type { Metadata } from 'next';
import { TermsOfServiceContent } from './TermsOfServiceContent';
import { seoConfig } from '../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.termsOfService.title,
  description: seoConfig.termsOfService.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.termsOfService.url}`,
  },
  openGraph: {
    title: seoConfig.termsOfService.title,
    description: seoConfig.termsOfService.description,
    url: `https://knowbuild.com${seoConfig.termsOfService.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.termsOfService.title,
    description: seoConfig.termsOfService.description,
  },
};

export default function TermsOfServicePage() {
  return <TermsOfServiceContent />;
}







