import React from 'react';
import Link from 'next/link';

export const Footer: React.FC = () => {
  return (
    <footer className="bg-slate-900/95 dark:bg-[#050a14] text-slate-400 py-16 border-t border-slate-800 backdrop-blur-lg">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid md:grid-cols-4 gap-12 mb-12">
          <div className="col-span-1 md:col-span-2">
            <div className="mb-6">
              <img src="https://knowbuildwebsiteassets.s3.ap-south-1.amazonaws.com/logo.svg" alt="knowbuild" className="h-8" />
            
            </div>
            <p className="max-w-sm text-slate-400 text-sm leading-relaxed mb-6">
              The operating system for high-growth B2B SMEs.
              We connect your inquiries, sales, finance, and operations into one seamless flow.
            </p>
            <div className="flex gap-4">
              {/* Social placeholders */}
              {/* <div className="w-8 h-8 bg-slate-800 rounded-full hover:bg-brand-blue transition-colors cursor-pointer"></div>
              <div className="w-8 h-8 bg-slate-800 rounded-full hover:bg-brand-blue transition-colors cursor-pointer"></div>
              <div className="w-8 h-8 bg-slate-800 rounded-full hover:bg-brand-blue transition-colors cursor-pointer"></div> */}
            </div>
          </div>

          <div>
            <h4 className="text-white font-bold mb-6 tracking-wide">Product</h4>
            <ul className="space-y-3 text-sm">
              <li><Link href="/solutions/b2b-qerp-crm" className="hover:text-brand-teal transition-colors">Solutions</Link></li>
              <li><Link href="/pricing/b2b-qerp-crm" className="hover:text-brand-teal transition-colors">Pricing</Link></li>
              <li><Link href="/mindset-grow-your-sme" className="hover:text-brand-teal transition-colors">Mindset</Link></li>
              <li><Link href="/forum" className="hover:text-brand-teal transition-colors">Forum</Link></li>
            </ul>
          </div>

          <div>
            <h4 className="text-white font-bold mb-6 tracking-wide">Company</h4>
            <ul className="space-y-3 text-sm">
              <li><Link href="/contact" className="hover:text-brand-teal transition-colors">Contact</Link></li>
              <li><Link href="/book-demo" className="hover:text-brand-teal transition-colors">Book a Demo</Link></li>
              <li><Link href="/privacy-policy" className="hover:text-brand-teal transition-colors">Privacy Policy</Link></li>
              <li><Link href="/terms-of-service" className="hover:text-brand-teal transition-colors">Terms of Service</Link></li>
            </ul>
          </div>
        </div>

        <div className="border-t border-slate-800 pt-8 flex flex-col md:flex-row justify-between items-center text-xs text-slate-500">
       
          <p>
            &copy; {new Date().getFullYear()} KnowBuild Business Software Private Limited. All rights reserved.
          </p>
          <p className="mt-2 md:mt-0 flex items-center gap-2">
            <span className="w-2 h-2 rounded-full bg-brand-orange"></span>
            Made with ❤️ for B2B SMEs
          </p>
        </div>
      </div>
    </footer>
  );
};