import React from 'react';

const organizationSchema = {
  '@context': 'https://schema.org',
  '@type': 'Organization',
  name: 'KnowBuild',
  url: 'https://knowbuild.com',
  logo: 'https://knowbuild.com/android-chrome-512x512.png',
  description:
    'KnowBuild\'s Q-ERP.CRM - an integrated CRM and ERP business operating system built for growing SMEs. Automate sales, finance, inventory, and much more.',
  foundingDate: '2020',
  sameAs: [] as string[],
};

export function JsonLd() {
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(organizationSchema) }}
    />
  );
}
