'use client';

import React from 'react';
import Link from 'next/link';
import { ArrowRight, Briefcase, Calculator, TrendingUp, Truck, UserCheck, Users } from 'lucide-react';
import { motion } from 'framer-motion';
// Image import removed - not used in component
import { modulesData } from './Solutions';

const roles = [
  {
    title: 'Managing Director',
    desc: 'View real-time growth, margins, and health.',
    icon: TrendingUp,
    color: 'text-blue-600 bg-blue-50 dark:bg-blue-900/30 dark:text-blue-400'
  },
  {
    title: 'Sales Team',
    desc: 'Auto-assign & revise quotes in seconds.',
    icon: Briefcase,
    color: 'text-indigo-600 bg-indigo-50 dark:bg-indigo-900/30 dark:text-indigo-400'
  },
  {
    title: 'Finance Head',
    desc: 'Control credit & collections without chasing.',
    icon: Calculator,
    color: 'text-emerald-600 bg-emerald-50 dark:bg-emerald-900/30 dark:text-emerald-400'
  },
  {
    title: 'Operations',
    desc: 'Get purchase suggestions & stock alerts.',
    icon: Truck,
    color: 'text-amber-600 bg-amber-50 dark:bg-amber-900/30 dark:text-amber-400'
  },
  {
    title: 'Inbound Sales',
    desc: 'Never miss or lose an inquiry again.',
    icon: UserCheck,
    color: 'text-rose-600 bg-rose-50 dark:bg-rose-900/30 dark:text-rose-400'
  },
  {
    title: 'Sales Manager',
    desc: 'Track funnels & hit rates in real-time.',
    icon: Users,
    color: 'text-purple-600 bg-purple-50 dark:bg-purple-900/30 dark:text-purple-400'
  },
];

// Double the array for seamless loop
const marqueeRoles = [...roles, ...roles];

export const RoleStrip: React.FC = () => {
  return (
    <div className="border-y border-slate-200/30 dark:border-slate-800/30 bg-white/30 dark:bg-slate-900/30 backdrop-blur-md py-10 relative">
      
      {/* Gradient Fade Edges */}
      <div className="absolute left-0 top-0 bottom-0 w-20 bg-gradient-to-r from-white/80 dark:from-[#0B1220]/80 to-transparent z-10" />
      <div className="absolute right-0 top-0 bottom-0 w-20 bg-gradient-to-l from-white/80 dark:from-[#0B1220]/80 to-transparent z-10" />

      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mb-8">
        <p className="text-md font-bold text-brand-navy dark:text-white uppercase tracking-widest text-center">
          Transforming the day for every business function And role
        </p>
      </div>
      <div className="flex overflow-hidden">
        <motion.div 
          className="flex gap-6 px-6"
          animate={{ x: ["-50%", "0%"] }}
          transition={{ duration: 30, ease: "linear", repeat: Infinity }}
        >
          {modulesData.map((role, index) => (
             <Link
          key={index}
          href="/solutions/b2b-qerp-crm#business-modules"
          className="group relative inline-flex items-center justify-center rounded-full focus:outline-none focus-visible:ring-2 focus-visible:ring-brand-orange/60 focus-visible:ring-offset-2 focus-visible:ring-offset-white dark:focus-visible:ring-offset-[#0B1220]"
          aria-label="Explore Q-ERP.CRM Business Modules"
        >    <div 
        key={index} 
        className="flex-shrink-0 w-72 p-5 rounded-2xl border border-white/60 dark:border-slate-700/60 bg-white/80 dark:bg-slate-800/50 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300"
      >
        <div className={`w-10 h-10 rounded-xl flex items-center justify-center mb-3 ${role.accent} ${role.accentBg} shadow-inner`}>
          <role.icon size={20} />
        </div>
        <h3 className="font-bold text-brand-navy dark:text-white mb-1 text-lg">{role.title}</h3>
        <p className="text-sm text-slate-600 dark:text-slate-400 leading-snug font-medium">{role.desc}</p>
      </div></Link>
        
          ))}
        </motion.div>
      </div>
     
      
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-8 mb-2 flex justify-center relative mb-6 z-20">
        <Link
          href="/solutions/b2b-qerp-crm#business-modules"
          className="group relative inline-flex items-center justify-center rounded-full focus:outline-none focus-visible:ring-2 focus-visible:ring-brand-orange/60 focus-visible:ring-offset-2 focus-visible:ring-offset-white dark:focus-visible:ring-offset-[#0B1220]"
          aria-label="Explore Q-ERP.CRM Business Modules"
        >
          {/* Soft outer glow (allowed to overflow) */}
          <span
            aria-hidden
            className="pointer-events-none absolute -inset-6 rounded-full bg-brand-orange/20 blur-3xl opacity-50 group-hover:opacity-90 transition-opacity duration-300"
          />

          {/* Beam border wrapper (clips gradient to ring) */}
          <span className="relative inline-flex rounded-full p-[2px] overflow-hidden">
            {/* Rotating conic gradient beam */}
            <span
              aria-hidden
              className="absolute inset-[-200%] rounded-full bg-[conic-gradient(from_180deg_at_50%_50%,rgba(254,108,0,0),rgba(254,108,0,0.95),rgba(56,189,248,0.9),rgba(254,108,0,0))] animate-[spin_6s_linear_infinite] motion-reduce:animate-none"
            />

            {/* Button surface */}
            <span className="relative z-10 inline-flex items-center gap-3 rounded-full bg-white/85 dark:bg-slate-900/70 px-7 py-3 text-brand-navy dark:text-white font-bold tracking-wide shadow-xl backdrop-blur-md border border-white/40 dark:border-white/10">
              <span className="text-sm sm:text-base">Explore Business Modules</span>
              <span className="relative inline-flex items-center justify-center">
                <span className="absolute -inset-1 rounded-full bg-brand-orange/30 blur-md opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                <ArrowRight className="relative w-5 h-5 text-brand-orange group-hover:translate-x-0.5 transition-transform duration-300" />
              </span>
            </span>
          </span>
        </Link>
      </div>
      <div className="flex overflow-hidden">
        <motion.div 
          className="flex gap-6 px-6"
          animate={{ x: ["0%", "-50%"] }}
          transition={{ duration: 30, ease: "linear", repeat: Infinity }}
        >
          {marqueeRoles.map((role, index) => (
            <div 
              key={index} 
              className="flex-shrink-0 w-72 p-5 rounded-2xl border border-white/60 dark:border-slate-700/60 bg-white/80 dark:bg-slate-800/50 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300"
            >
              <div className={`w-10 h-10 rounded-xl flex items-center justify-center mb-3 ${role.color} shadow-inner`}>
                <role.icon size={20} />
              </div>
              <h3 className="font-bold text-brand-navy dark:text-white mb-1 text-lg">{role.title}</h3>
              <p className="text-sm text-slate-600 dark:text-slate-400 leading-snug font-medium">{role.desc}</p>
            </div>
          ))}
        </motion.div>
      </div>
      
    </div>
  );
};
