
import React from 'react';
import { Section } from './ui/Section';
import { ShieldCheck, Zap, HeartHandshake } from 'lucide-react';

const pillars = [
  {
    title: "Enterprise Security",
    desc: "Bank-level data encryption and strict access controls keep your business data safe.",
    icon: ShieldCheck
  },
  {
    title: "Lightning Fast",
    desc: "Optimized for speed. Search thousands of products or clients instantly.",
    icon: Zap
  },
  {
    title: "Built for SMEs",
    desc: "Designed for how Indian B2B SMEs actually work, not generic enterprise theory.",
    icon: HeartHandshake
  }
];

export const Trust: React.FC = () => {
  return (
    <Section bgColor="light" id="trust" theme="mindset">
      <div className="grid md:grid-cols-3 gap-8">
        {pillars.map((p, i) => (
          <div key={i} className="flex gap-4">
            <div className="flex-shrink-0 mt-1 text-brand-blue dark:text-brand-lightBlue">
              <p.icon size={32} />
            </div>
            <div>
              <h3 className="text-lg font-bold text-brand-navy dark:text-white mb-2">{p.title}</h3>
              <p className="text-slate-600 dark:text-slate-400 text-sm">{p.desc}</p>
            </div>
          </div>
        ))}
      </div>
      
      <div className="mt-16 pt-8 border-t border-slate-200/50 dark:border-slate-800/50 text-center">
        <p className="text-slate-500 dark:text-slate-400 font-medium mb-6">Trusted by leading SMEs across manufacturing, distribution & engineering</p>
        <div className="flex flex-wrap justify-center gap-8 opacity-50 dark:opacity-40 grayscale invert-0 dark:invert">
           {/* Placeholder Logos */}
           {[1,2,3,4,5].map((n) => (
             <div key={n} className="h-8 w-24 bg-slate-300 dark:bg-slate-600 rounded"></div>
           ))}
        </div>
      </div>
    </Section>
  );
};
