import * as React from 'react';

type TextComponentProps = React.HTMLAttributes<HTMLHeadingElement>;

export function TextComponent({ className = '', children, ...props }: TextComponentProps) {
  return (
    <h2
      className={[
        'text-center text-3xl md:text-5xl font-bold',
        'text-brand-navy dark:text-white',
        'leading-tight',
        className,
      ].join(' ')}
      {...props}
    >
      {children}
    </h2>
  );
}











