'use client';

import React from 'react';
import { motion } from 'framer-motion';
import { ThemeId } from '../../types/theme';
import { useSectionTheme } from '../../hooks/useSectionTheme';

interface SectionProps {
  children: React.ReactNode;
  className?: string;
  id?: string;
  bgColor?: 'white' | 'light';
  noPadding?: boolean;
  theme?: ThemeId;
}

export const Section: React.FC<SectionProps> = ({
  children,
  className = '',
  id,
  bgColor = 'white',
  noPadding = false,
  theme
}) => {
  const themeRef = useSectionTheme(theme);

  return (
    <section
      ref={themeRef}
      id={id}
      className={`relative ${!noPadding ? 'py-20 pt-0' : ''} px-4 sm:px-6 lg:px-8 ${bgColor === 'light' ? 'bg-transparent' : 'bg-transparent'} ${className}`}
    >
      <motion.div
        initial={{ opacity: 0, y: 40 }}
        whileInView={{ opacity: 1, y: 0 }}
        viewport={{ once: true, margin: "-100px" }}
        transition={{ duration: 0.8, ease: [0.21, 0.47, 0.32, 0.98] }}
        className="max-w-7xl mx-auto relative z-10"
      >
        {children}
      </motion.div>
    </section>
  );
};
