import * as React from 'react';

export type BadgeProps = React.HTMLAttributes<HTMLDivElement>;

export function Badge({ className = '', ...props }: BadgeProps) {
  return (
    <div
      className={[
        'inline-flex items-center rounded-full px-3 py-1 text-xs font-semibold tracking-wide',
        'bg-brand-blue/10 text-brand-blue',
        'dark:bg-brand-blue/20 dark:text-blue-100',
        className,
      ].join(' ')}
      {...props}
    />
  );
}











