import type { Metadata } from 'next';

type GetMetadataArgs = {
  title: string;
  description: string;
  canonical?: string;
};

export function getMetadata({ title, description, canonical }: GetMetadataArgs): Metadata {
  return {
    title,
    description,
    alternates: canonical ? { canonical } : undefined,
    openGraph: {
      title,
      description,
      type: 'website',
      url: canonical,
      siteName: 'knowbuild',
    },
    twitter: {
      card: 'summary_large_image',
      title,
      description,
    },
  };
}











