/** @type {import('tailwindcss').Config} */
module.exports = {
	darkMode: 'class',
	content: [
		'./app/**/*.{js,ts,jsx,tsx,mdx}',
		'./pages/**/*.{js,ts,jsx,tsx,mdx}',
		'./components/**/*.{js,ts,jsx,tsx,mdx}',
	],
	theme: {
		extend: {
			fontFamily: {
				sans: [
					'Manrope',
					'sans-serif'
				]
			},
			colors: {
				brand: {
					blue: '#0052CC',
					lightBlue: '#3375D6',
					orange: '#FE6C00',
					lightOrange: '#F19058',
					teal: '#00CEC2',
					lightTeal: '#7BD3D0',
					navy: '#0B1220'
				},
				background: 'hsl(var(--background))',
				foreground: 'hsl(var(--foreground))',
				card: {
					DEFAULT: 'hsl(var(--card))',
					foreground: 'hsl(var(--card-foreground))'
				},
				popover: {
					DEFAULT: 'hsl(var(--popover))',
					foreground: 'hsl(var(--popover-foreground))'
				},
				primary: {
					DEFAULT: 'hsl(var(--primary))',
					foreground: 'hsl(var(--primary-foreground))'
				},
				secondary: {
					DEFAULT: 'hsl(var(--secondary))',
					foreground: 'hsl(var(--secondary-foreground))'
				},
				muted: {
					DEFAULT: 'hsl(var(--muted))',
					foreground: 'hsl(var(--muted-foreground))'
				},
				accent: {
					DEFAULT: 'hsl(var(--accent))',
					foreground: 'hsl(var(--accent-foreground))'
				},
				destructive: {
					DEFAULT: 'hsl(var(--destructive))',
					foreground: 'hsl(var(--destructive-foreground))'
				},
				border: 'hsl(var(--border))',
				input: 'hsl(var(--input))',
				ring: 'hsl(var(--ring))',
				chart: {
					'1': 'hsl(var(--chart-1))',
					'2': 'hsl(var(--chart-2))',
					'3': 'hsl(var(--chart-3))',
					'4': 'hsl(var(--chart-4))',
					'5': 'hsl(var(--chart-5))'
				}
			},
			boxShadow: {
				glow: '0 0 40px -10px rgba(0, 82, 204, 0.3)',
				'glow-orange': '0 0 40px -10px rgba(254, 108, 0, 0.4)',
				glass: '0 8px 32px 0 rgba(31, 38, 135, 0.07)',
				'inner-light': 'inset 0 1px 0 0 rgba(255, 255, 255, 0.4)'
			},
			backgroundImage: {
				'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))'
			},
			animation: {
				float: 'float 6s ease-in-out infinite'
			},
			keyframes: {
				float: {
					'0%, 100%': {
						transform: 'translateY(0)'
					},
					'50%': {
						transform: 'translateY(-20px)'
					}
				}
			},
			screens: {
				xs: '475px',
				sm: '640px',
				md: '768px',
				lg: '1024px',
				xl: '1280px',
				'2xl': '1536px',
				'zoom-sm': '853px',
				'zoom-md': '1024px',
				'zoom-lg': '1280px',
				'zoom-xl': '1707px'
			},
			fontSize: {
				'fluid-xs': [
					'clamp(0.75rem, 0.7rem + 0.25vw, 0.875rem)',
					{
						lineHeight: '1.5'
					}
				],
				'fluid-sm': [
					'clamp(0.875rem, 0.8rem + 0.375vw, 1rem)',
					{
						lineHeight: '1.5'
					}
				],
				'fluid-base': [
					'clamp(1rem, 0.95rem + 0.25vw, 1.125rem)',
					{
						lineHeight: '1.5'
					}
				],
				'fluid-lg': [
					'clamp(1.125rem, 1rem + 0.625vw, 1.25rem)',
					{
						lineHeight: '1.5'
					}
				],
				'fluid-xl': [
					'clamp(1.25rem, 1.1rem + 0.75vw, 1.5rem)',
					{
						lineHeight: '1.4'
					}
				],
				'fluid-2xl': [
					'clamp(1.5rem, 1.3rem + 1vw, 1.875rem)',
					{
						lineHeight: '1.3'
					}
				],
				'fluid-3xl': [
					'clamp(1.875rem, 1.5rem + 1.875vw, 2.25rem)',
					{
						lineHeight: '1.2'
					}
				],
				'fluid-4xl': [
					'clamp(2.25rem, 1.8rem + 2.25vw, 3rem)',
					{
						lineHeight: '1.1'
					}
				],
				'fluid-5xl': [
					'clamp(3rem, 2.4rem + 3vw, 4rem)',
					{
						lineHeight: '1.1'
					}
				],
				'fluid-6xl': [
					'clamp(3.75rem, 3rem + 3.75vw, 4.5rem)',
					{
						lineHeight: '1'
					}
				],
				'fluid-7xl': [
					'clamp(4.5rem, 3.6rem + 4.5vw, 5.5rem)',
					{
						lineHeight: '1'
					}
				]
			},
			spacing: {
				'fluid-xs': 'clamp(0.5rem, 0.4rem + 0.5vw, 0.75rem)',
				'fluid-sm': 'clamp(0.75rem, 0.6rem + 0.75vw, 1rem)',
				'fluid-md': 'clamp(1rem, 0.8rem + 1vw, 1.5rem)',
				'fluid-lg': 'clamp(1.5rem, 1.2rem + 1.5vw, 2rem)',
				'fluid-xl': 'clamp(2rem, 1.6rem + 2vw, 3rem)',
				'fluid-2xl': 'clamp(3rem, 2.4rem + 3vw, 4rem)'
			},
			borderRadius: {
				lg: 'var(--radius)',
				md: 'calc(var(--radius) - 2px)',
				sm: 'calc(var(--radius) - 4px)'
			}
		}
	},
	plugins: [require("tailwindcss-animate")],
};
















