import { Object3DNode } from '@react-three/fiber';
import * as THREE from 'three';

// Extend Three elements for R3F
declare global {
  namespace JSX {
    interface IntrinsicElements {
      mesh: Object3DNode<THREE.Mesh, typeof THREE.Mesh>;
      planeGeometry: Object3DNode<THREE.PlaneGeometry, typeof THREE.PlaneGeometry>;
      gradientMaterial: Object3DNode<THREE.ShaderMaterial, typeof THREE.ShaderMaterial> & {
        uTime?: number;
        uColorA?: THREE.Color;
        uColorB?: THREE.Color;
        uColorC?: THREE.Color;
        uColorD?: THREE.Color;
        uBackground?: THREE.Color;
        uMouse?: THREE.Vector2;
        uDarkMode?: number;
        uAccent?: THREE.Color;
      };
      fluidGradientMaterial: Object3DNode<THREE.ShaderMaterial, typeof THREE.ShaderMaterial> & {
        uTime?: number;
        uColorA?: THREE.Color;
        uColorB?: THREE.Color;
        uColorC?: THREE.Color;
        uColorD?: THREE.Color;
        uBackground?: THREE.Color;
        uMouse?: THREE.Vector2;
        uResolution?: THREE.Vector2;
        uDarkMode?: number;
        uAccent?: THREE.Color;
      };
    }
  }
}
